{ TLabel   ,  
     .

       (   
  )   : www.chat.ru/~z_ol
           Delphi,
      .

  (c)  .. e-mail: merlin_twi@mail.ru
}

unit Label3DF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ExtCtrls;

type
  TLabel3DFBevel = (blNone,blLowered,blRaised,blShadow);
  TGradientOrientation = (goHorizontal, goVertical);
  TLabel3DFBorderStyle = (lbNone, lbNormal, lbLowered, lbRaised, lbInn, lbOut);
  TLabel3DF = class(TLabel)
  private
    FHighLightColor: TColor;
    FShadowColor: TColor;
    FBevel: TLabel3DFBevel;
    FShadowSize: Byte;
    FFirstColor, FLastColor : TColor;
    FFillGradient : boolean;
    FFillOrientation : TGradientOrientation;
    FBorderColor : TColor;
    FBorderWidth : integer;
    FBorderStyle : TLabel3DFBorderStyle;

    procedure DoDrawText(var Rect: TRect;Flags: Word);
    procedure SetBevel(Value: TLabel3DFBevel);
    procedure SetHighLightColor(Value: TColor);
    procedure SetShadowColor(Value: TColor);
    procedure SetShadowSize(Value: Byte);
    procedure SetFirstColor(Value: TColor);
    procedure SetLastColor(Value: TColor);
    procedure SetBorderColor(Value: TColor);
    procedure SetFillGradient(Value: boolean);
    procedure SetFillOrientation(Value : TGradientOrientation);
    procedure SetBorderWidth(Value : integer);
    procedure SetLabelBorderStyle(Value : TLabel3DFBorderStyle);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property FirstColor : TColor read FFirstColor write SetFirstColor;
    property LastColor : TColor read FLastColor write SetLastColor;
    property FillGradient : boolean read FFillGradient write SetFillGradient;
    property GradientOrientation : TGradientOrientation read FFillOrientation write SetFillOrientation;
    property HighLightColor: TColor read FHighLightColor
      write SetHighLightColor default clBtnHighLight;
    property ShadowColor: TColor read FShadowColor
      write SetShadowColor default clBtnShadow;
    property Bevel: TLabel3DFBevel read FBevel
      write SetBevel default blRaised;
    property ShadowSize: Byte read FShadowSize
      write SetShadowSize default 1;
    property BorderColor : TColor read FBorderColor write SetBorderColor;
    property BorderWidth : integer read FBorderWidth write SetBorderWidth;
    property BorderStyle : TLabel3DFBorderStyle read FBorderStyle write SetLabelBorderStyle;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Standard', [TLabel3DF]);
end;

{ class TLabel3DF }
constructor TLabel3DF.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  AutoSize:=false;
  FHighLightColor:=clBtnHighLight;
  FShadowColor:=clBtnShadow;
  FBevel:=blRaised;
  FShadowSize:=1;
  FFillGradient:=false;
  FFirstColor:=clWhite;
  FLastColor:=clTeal;
  FFillOrientation:=goHorizontal;
  FBorderColor:=clBlack;
  FBorderWidth:=1;
  FBorderStyle:=lbNone;
end;

procedure TLabel3DF.DoDrawText(var Rect: TRect;Flags: Word);
var
  Text: string;

procedure DoDrawShadowText(ColorHigh,ColorLow: TColor);
var
  R: TRect;
begin
  {High shadow text}
  if FBevel <> blShadow then begin
    R:=Rect;
    OffsetRect(R,-FShadowSize,-FShadowSize);
    Canvas.Font.Color:=ColorHigh;
    if Enabled then
      DrawText(Canvas.Handle,PChar(Text),Length(Text),R,Flags);
  end;
  {Low shadow text}
  R:=Rect;
  OffsetRect(R,FShadowSize,FShadowSize);
  Canvas.Font.Color:=ColorLow;
  DrawText(Canvas.Handle,PChar(Text),Length(Text),R,Flags);
  {Text}
  Canvas.Font:=Font;
  if not Enabled then Canvas.Font.Color:=clGrayText;
  DrawText(Canvas.Handle,PChar(Text),Length(Text),Rect,Flags);
end;

begin
  Text:=GetLabelText;
  if (Flags and DT_CALCRECT <> 0) and ((Text = '') or ShowAccelChar and
    (Text[1] = '&') and (Text[2] = #0)) then Text:=Text+' ';
  if not ShowAccelChar then Flags:=Flags or DT_NOPREFIX;
  Canvas.Font:=Font;
  if FBevel = blNone then
    DrawText(Canvas.Handle,PChar(Text),Length(Text),Rect,Flags)
  else
    case FBevel of
      blRaised : DoDrawShadowText(FHighLightColor,FShadowColor);
      blLowered: DoDrawShadowText(FShadowColor,FHighLightColor);
      blShadow : DoDrawShadowText(0,FShadowColor);
    end;
end;

procedure DoFillGradient(Canvas: TCanvas; Rc: TRect;
          LeftTopColor, RightBottomColor: TColor; Orientation: TGradientOrientation);
var
   LR, LG, LB, RR, RG, RB, MR, MG, MB: Integer; //Left, Right, and Mix RGBs
   i, LeftRGB, RightRGB, LeftWeight, RightWeight, Times: Longint;
   MixColor: TColor;
begin
     LeftRGB:=ColorToRGB(LeftTopColor);
     LR:=GetRValue(LeftRGB);
     LG:=GetGValue(LeftRGB);
     LB:=GetBValue(LeftRGB);
     RightRGB:=ColorToRGB(RightBottomColor);
     RR:=GetRValue(RightRGB);
     RG:=GetGValue(RightRGB);
     RB:=GetBValue(RightRGB);
     if Orientation = goHorizontal then Times:=Rc.Right-Rc.Left-1
     else Times:=Rc.Bottom-Rc.Top-1;
     if Times > 0 then
     begin
          for i:=0 to Times do
          begin
               LeftWeight:=Times-i;
               RightWeight:=i;
               MR:=(LR*LeftWeight+RR*RightWeight) div Times;
               MG:=(LG*LeftWeight+RG*RightWeight) div Times;
               MB:=(LB*LeftWeight+RB*RightWeight) div Times;
               MixColor:=RGB(MR, MG, MB);
               with Canvas do begin
                Brush.Color:=MixColor;
                if Orientation = goHorizontal then
                   FillRect(Rect(Rc.Left+i, Rc.Top, Rc.Left+i+1, Rc.Bottom))
                else
                    FillRect(Rect(Rc.Left, Rc.Top+i, Rc.Right, Rc.Top+i+1));
               end;
          end;
     end;
end;

procedure TLabel3DF.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  R, Rect: TRect;
  TopColor, BottomColor: TColor;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    TopColor := clBtnHighlight;
    if Bevel = bvLowered then TopColor := clBtnShadow;
    BottomColor := clBtnShadow;
    if Bevel = bvLowered then BottomColor := clBtnHighlight;
  end;

begin
  with Canvas do begin
    Rect:=ClientRect;
    case FBorderStyle of
     lbNormal: Frame3D(Canvas, Rect, FBorderColor, FBorderColor, BorderWidth);
     lbLowered: begin
                  AdjustColors(bvLowered);
                  Frame3D(Canvas, Rect, TopColor, BottomColor, BorderWidth);
                end;
     lbRaised: begin
                  AdjustColors(bvRaised);
                  Frame3D(Canvas, Rect, TopColor, BottomColor, BorderWidth);
               end;
     lbInn: begin
              AdjustColors(bvLowered);
              Frame3D(Canvas, Rect, TopColor, BottomColor, BorderWidth);
              AdjustColors(bvRaised);
              Frame3D(Canvas, Rect, TopColor, BottomColor, BorderWidth);
            end;
     lbOut: begin
              AdjustColors(bvRaised);
              Frame3D(Canvas, Rect, TopColor, BottomColor, BorderWidth);
              AdjustColors(bvLowered);
              Frame3D(Canvas, Rect, TopColor, BottomColor, BorderWidth);
            end;
    end;
    if FFillGradient then
      DoFillGradient(Canvas,Rect,FFirstColor,FLastColor,FFillOrientation)
    else if not Transparent then begin
      Brush.Color:=Self.Color;
      Brush.Style:=bsSolid;
      FillRect(Rect);
    end;
    Brush.Style:=bsClear;
    if Layout<>tlTop then begin
     R:=Rect;
     DoDrawText(R,(DT_EXPANDTABS or DT_WORDBREAK) or
       Alignments[Alignment] or DT_CalcRect);
     if (R.Bottom-R.Top)<(Rect.Bottom-Rect.Top) then begin
      if Layout=tlCenter then
        OffsetRect(Rect, 0, ((Rect.Bottom-Rect.Top)-(R.Bottom-R.Top)) div 2)
      else
        OffsetRect(Rect, 0, (Rect.Bottom-Rect.Top)-(R.Bottom-R.Top))
     end;
    end;
    DoDrawText(Rect,(DT_EXPANDTABS or DT_WORDBREAK) or
       Alignments[Alignment]);
  end;
end;

procedure TLabel3DF.SetBevel(Value: TLabel3DFBevel);
begin
  if FBevel <> Value then
  begin
    FBevel:=Value;
    Invalidate;
  end;
end;

procedure TLabel3DF.SetHighLightColor(Value: TColor);
begin
  if FHighLightColor <> Value then
  begin
    FHighLightColor:=Value;
    Invalidate;
  end;
end;

procedure TLabel3DF.SetShadowColor(Value: TColor);
begin
  if FShadowColor <> Value then
  begin
    FShadowColor:=Value;
    Invalidate;
  end;
end;

procedure TLabel3DF.SetShadowSize(Value: Byte);
begin
  if FShadowSize <> Value then
  begin
    FShadowSize:=Value;
    Invalidate;
  end;
end;

procedure TLabel3DF.SetFirstColor(Value: TColor);
begin
  if FFirstColor <> Value then begin
    FFirstColor:=Value; Invalidate;
  end;
end;

procedure TLabel3DF.SetLastColor(Value: TColor);
begin
  if FLastColor <> Value then begin
    FLastColor:=Value; Invalidate;
  end;
end;

procedure TLabel3DF.SetFillGradient(Value: boolean);
begin
  if FFillGradient <> Value then begin
    FFillGradient:=Value; Invalidate;
  end;
end;

procedure TLabel3DF.SetFillOrientation(Value : TGradientOrientation);
begin
  if FFillOrientation <> Value then begin
    FFillOrientation:=Value; Invalidate;
  end;
end;

procedure TLabel3DF.SetBorderColor(Value: TColor);
begin
  if FBorderColor <> Value then begin
    FBorderColor:=Value; Invalidate;
  end;
end;

procedure TLabel3DF.SetBorderWidth(Value : integer);
begin
  if FBorderWidth <> Value then begin
    FBorderWidth:=Value; Invalidate;
  end;
end;

procedure TLabel3DF.SetLabelBorderStyle;
begin
  if FBorderStyle <> Value then begin
    FBorderStyle:=Value; Invalidate;
  end;
end;

end.
