unit StProgressIndicatorEditor;

interface
uses
  DesignIntf, DesignEditors;

type
   TStProgressIndicatorEditor = Class(TComponentEditor)
   public
    Function GetVerbCount: Integer; override;
    Function GetVerb(Index: Integer): String; override;
    procedure ExecuteVerb(Index: Integer); override;
   end;

procedure Register;

implementation
uses TestUnit, SysUtils, Controls, StProgressIndicator;

procedure Register;
begin
  RegisterComponentEditor(TStProgressIndicator, TStProgressIndicatorEditor)
end;

{ TStProgressIndicatorEditor }

procedure TStProgressIndicatorEditor.ExecuteVerb(Index: Integer);
begin
  inherited;
  TestForm:=TTestForm.Create(nil);
  TestForm.ShowModal;
  FreeAndNil(TestForm);
end;

function TStProgressIndicatorEditor.GetVerb(Index: Integer): String;
begin
  Result := 'Show running';
end;

function TStProgressIndicatorEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

end.
