{*******************************************************************************************************************
* :  KUAW Soft                                                                                         *
*  : 17.03.2002                                                                                        *
*  : 18.05.2002                                                                                  *
* :    Version     kaCtrls                                         *
* [TO DO]                                                                                                          *
* [BUGS]                                                                                                           *
* [IDEAS]                                                                                                          *
*******************************************************************************************************************}

unit kaCtrlsVersionPE;

{$I KUAW.inc}
{$I kaCtrlsPE.inc}

interface

uses
{ }
 Windows,

 {$IFDEF KA_D6}
 DesignIntf, DesignEditors,
 {$ELSE}
 DsgnIntf,
 {$ENDIF}

{ }
 kaCtrlsConsts;

type
{*******************************************************************************************************************
*      Version                                                                  *
*******************************************************************************************************************}
 TkaCtrlsVersionPropertyEditor = class(TStringProperty)
 public
  function  GetAttributes: TPropertyAttributes; override;
  function  GetValue: string; override;
  procedure Edit; override;
 end;

implementation

//   ,                                                             *
{$IFOPT D+}
 {$DEFINE KA_DEBUG_INFO}
 {$D-}
{$ENDIF}

function TkaCtrlsVersionPropertyEditor.GetAttributes: TPropertyAttributes;
begin
 Result := inherited GetAttributes + [paReadOnly, paDialog];
end;

function TkaCtrlsVersionPropertyEditor.GetValue : string;
begin
 Result := KA_CTRLS_VERSION;
end;

procedure TkaCtrlsVersionPropertyEditor.Edit;
var Header, Msg: string;
begin
 Header := S_ABOUT;
 Msg    := KA_CTRLS_PRODUCT_NAME + CRLF
         + S_VERSION + KA_CTRLS_VERSION + CRLF + CRLF
         + S_COMPONENT + GetComponent(0).ClassName + CRLF + CRLF
         + KA_E_MAIL + CRLF + KA_COPYRIGHT;

 MessageBox(0, PChar(Msg), PChar(Header), MB_ICONINFORMATION);
end;

//                                                                               *
{$IFDEF KA_DEBUG_INFO}
 {$UNDEF KA_DEBUG_INFO}
 {$D+}
{$ENDIF}

end.