{*******************************************************************************************************************
* :  KUAW Soft                                                                                         *
*  : 30.12.2001                                                                                        *
*  : 16.05.2002                                                                                  *
* :     .   ,   .                   *
* [TO DO]                                                                                                          *
* [BUGS]                                                                                                           *
* [IDEAS]                                                                                                          *
*******************************************************************************************************************}

unit kaTypes;

{$I KUAW.inc}
{$I kaUtils.inc}

interface

uses
 { }
 Classes, Graphics;

type
{*******************************************************************************************************************
* :                                                                                                      *
*  kaHorizontal:                                                                                      *
*  kaVerticalCW:   (   )                                                         *
*  kaVerticalCCW:  (   )                                                     *
*******************************************************************************************************************}
 TkaOrientation = (kaHorizontal, kaVerticalCW, kaVerticalCCW);

{*******************************************************************************************************************
*   :                                                                                           *
*  ahLeft:                                                                                             *
*  ahCenter:                                                                                             *
*  ahRight:                                                                                           *
*******************************************************************************************************************}
 TkaAlignmentH = (ahLeft, ahCenter, ahRight);

{*******************************************************************************************************************
*   :                                                                                           *
*  avTop:                                                                                            *
*  avCenter:                                                                                             *
*  avBottom:                                                                                          *
*******************************************************************************************************************}
 TkaAlignmentV = (avTop, avCenter, avBottom);

{*******************************************************************************************************************
*       ,                                                                         *
*  eetNone -                                                                                *
*  eetEndEllipsis  - ,      '...'                                                           *
*  eetPathEllipsis -   ,   ,    ,  :   *
*    'c:\...\SomeDir\SomeFile.SomeExt', ..     '...', ,      *
*      '\'                                                                                          *
*******************************************************************************************************************}
 TkaEndEllipsisType = (eetNone, eetEndEllipsis, eetPathEllipsis);

{*******************************************************************************************************************
*  LinkedControl-  Owner-:                                                                    *
*  lpTop:                                                                                                    *
*  lpLeft:                                                                                                    *
*  lpRight:                                                                                                  *
*  lpBottom:                                                                                                  *
*  lpNone:                                                                                                 *
*******************************************************************************************************************}
 TkaLinkagePosition = (lpTop, lpLeft, lpRight, lpBottom, lpNone);

{*******************************************************************************************************************
*  -:                                                                                          *
*  poLeft   -    (  ) /                                                    *
*  poTop    -    /                                                                             *
*  poRight  -    (  ) /                                                  *
*  poBottom -    /                                                                               *
*******************************************************************************************************************}
 TkaPosition = (poLeft, poTop, poRight, poBottom);

{*******************************************************************************************************************
*                                                                                     *
*  beLeft   -                                                                                            *
*  beTop    -                                                                                          *
*  beRight  -                                                                                           *
*  beBottom -                                                                                           *
*******************************************************************************************************************}
 TkaBorderEdge  = (beLeft, beTop, beRight, beBottom);
 TkaBorderEdges = set of TkaBorderEdge;

{*******************************************************************************************************************
*                                                                                        *
*  bvNone    -                                                                                                  *
*  bvLowered -                                                                                           *
*  bvRaised  -                                                                                          *
*******************************************************************************************************************}
 TkaBevelCut = (bvNone, bvLowered, bvRaised);

{*******************************************************************************************************************
*  :                                                                                                 *
* fspRect        -                                                                                    *
* fspRoundRect   -                                                                *
*******************************************************************************************************************}
 TkaFrameShape = (fspRect, fspRoundRect);

{*******************************************************************************************************************
*    :                                                                            *
*  fsNone       -                                                                                         *
*  fsCustom     -                                                                               *
*  fsSingle     -                                                                                  *
*  fsThick      -                                                                                    *
*  fsRaised     -                                                                                          *
*  fsLowered    -                                                                                        *
*  fsBump       -  +                                                                             *
*  fsGroove     -  +                                                                             *
*  fsButtonUp   -                                                                                 *
*  fsButtomDown -                                                                                  *
*  fsFlat       -                                                                                           *
*  fs3D         - 3D                                                                                               *
*******************************************************************************************************************}
 TkaFrameStyle = (fsNone, fsCustom, fsSingle, fsThick, fsRaised, fsLowered, fsBump, fsGroove, fsButtonUp, fsButtonDown, fsFlat, fs3D);

{*******************************************************************************************************************
*                                                                             *
*******************************************************************************************************************}
 TkaComplexProperty = class(TPersistent)
 private
  _OnChange: TNotifyEvent; //                                                              *
 protected
  UpdateCount: integer;    //                                                                     *

  //     - ,     Changed                            *
  procedure SetBooleanProperty(var Dest: boolean; NewValue: boolean);
  procedure SetIntegerProperty(var Dest: integer; NewValue: integer; IsAcceptNegative: boolean = true);
  procedure SetColorProperty(var Dest: TColor; NewValue: TColor);
  procedure SetStringProperty(var Dest: string; const NewValue: string);

  procedure Changed(Sender: TObject); virtual; //    ,                        *
 public
  procedure BeginUpdate; //   Changed,                             *
  procedure EndUpdate(IsCallChanged: boolean = true); // ,         *

  property OnChange: TNotifyEvent read _OnChange write _OnChange;
 end;

{*******************************************************************************************************************
*      ,                                       *
*******************************************************************************************************************}
 TkaRestorableProperty = class(TkaComplexProperty)
 protected
  procedure InternalRestoreDefaults;   virtual; //                                 *
  procedure InternalRestoreUnAssigned; virtual; //          *
 public
  procedure SetDefaults; virtual; //                                      *
  procedure RestoreDefaults;      //       Changed                    *
  procedure RestoreUnAssigned;    //        Changed       *
 end;

implementation

{ TkaComplexProperty }

procedure TkaComplexProperty.SetBooleanProperty(var Dest: boolean; NewValue: boolean);
begin
 if (Dest <> NewValue) then
  begin
   Dest := NewValue;
   Changed(Self);
  end;
end;

procedure TkaComplexProperty.SetIntegerProperty(var Dest: integer; NewValue: integer; IsAcceptNegative: boolean = true);
begin
 if (not IsAcceptNegative) and (NewValue < 0) then Exit;

 if (Dest <> NewValue) then
  begin
   Dest := NewValue;
   Changed(Self);
  end;
end;

procedure TkaComplexProperty.SetColorProperty(var Dest: TColor; NewValue: TColor);
begin
 if (Dest <> NewValue) then
  begin
   Dest := NewValue;
   Changed(Self);
  end;
end;

procedure TkaComplexProperty.SetStringProperty(var Dest: string; const NewValue: string);
begin
 if (Dest <> NewValue) then
  begin
   Dest := NewValue;
   Changed(Self);
  end;
end;

procedure TkaComplexProperty.Changed(Sender: TObject) ;
begin
 if ((UpdateCount = 0) and Assigned(OnChange)) then OnChange(Sender);
end;

procedure TkaComplexProperty.BeginUpdate;
begin
 Inc(UpdateCount);
end;

procedure TkaComplexProperty.EndUpdate(IsCallChanged: boolean = true);
begin
 if (UpdateCount > 1) then Dec(UpdateCount)
  else
   begin
    UpdateCount := 0;
    if (IsCallChanged) then Changed(Self);
   end;
end;

{ TkaRestorableProperty }

procedure TkaRestorableProperty.InternalRestoreDefaults;
begin
 //                                                                                   *
end;

procedure TkaRestorableProperty.InternalRestoreUnAssigned;
begin
 //                                                                                   *
end;

procedure TkaRestorableProperty.SetDefaults;
begin
 //                                                                           *
end;

procedure TkaRestorableProperty.RestoreDefaults;
begin
 BeginUpdate;
 try
  InternalRestoreDefaults;
 finally
  EndUpdate;
 end;
end;

procedure TkaRestorableProperty.RestoreUnAssigned;
begin
 BeginUpdate;
 try
  InternalRestoreUnAssigned;
 finally
  EndUpdate;
 end;
end;

end.
