{*******************************************************************************************************************
* :  KUAW Soft                                                                                         *
*  : 10.01.2002                                                                                        *
*  : 18.05.2002                                                                                  *
* :    Caption     kaCtrls                                         *
* [TO DO]                                                                                                          *
* [BUGS]                                                                                                           *
* [IDEAS]                                                                                                          *
*******************************************************************************************************************}

unit kaCaptionPE;

{$I KUAW.inc}
{$I kaCtrlsPE.inc}

interface

uses
 {$IFDEF KA_D6}
 DesignIntf, VCLEditors
 {$ELSE}
 DsgnIntf
 {$ENDIF}
 ;

type
{*******************************************************************************************************************
*      Caption                                                                  *
*******************************************************************************************************************}
 TkaCaptionPropertyEditor = class(TCaptionProperty)
 public
  function  GetAttributes: TPropertyAttributes; override;
  function  GetEditLimit: Integer; override;
  procedure Edit; override;
 end;

implementation

//   ,                                                             *
{$IFOPT D+}
 {$DEFINE KA_DEBUG_INFO}
 {$D-}
{$ENDIF}

uses Classes, TypInfo, Controls, Forms, {$IFDEF KA_D6}StringsEdit{$ELSE}StrEdit{$ENDIF} ;

function TkaCaptionPropertyEditor.GetAttributes: TPropertyAttributes;
begin
 Result := inherited GetAttributes + [paDialog];
end;

function TkaCaptionPropertyEditor.GetEditLimit: Integer;
begin
 if GetPropType^.Kind = tkString then Result := GetTypeData(GetPropType)^.MaxLength
  else Result := 1024;
end;

procedure TkaCaptionPropertyEditor.Edit;
var tmp: string;
 Src: TPersistent;
begin
 with {$IFDEF KA_D6}TStringsEditDlg{$ELSE}TStrEditDlg{$ENDIF}.Create(Application) do
  try
   Src := GetComponent(0);
   if (Src is TComponent) then Caption := TComponent(Src).Name + '.' + GetName
    else Caption := GetName;

   tmp := GetStrValue;

   Memo.Text := tmp;
   Memo.MaxLength := GetEditLimit;

   UpdateStatus(nil);

   if (ShowModal = mrOk) then
    begin
     tmp := Memo.Text;
     while (Length(tmp) > 0) and (tmp[Length(tmp)] < ' ') do
      System.Delete(tmp, Length(tmp), 1);

     SetStrValue(tmp);
    end;
  finally
    Free;
  end;
end;

//                                                                               *
{$IFDEF KA_DEBUG_INFO}
 {$UNDEF KA_DEBUG_INFO}
 {$D+}
{$ENDIF}

end.