unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActiveX, MSHTML, StdCtrls,httpsend,ComObj;

type
  TFMain = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label3: TLabel;
    ListBox1: TListBox;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    procedure LoadDocument(const URL:string);
  end;

var
  FMain: TFMain;
  Doc: IHTMLDocument2;

implementation

{$R *.dfm}

procedure TFMain.Button1Click(Sender: TObject);
var i,j:integer;
    Link: IHTMLElement;
    Parent: IHTMLElement;
    Child: IHTMLElementCollection;
    RelAttr,Anchor : string;
begin
LoadDocument(Edit1.Text);

for I := 0 to Doc.links.length - 1 do
  begin
    Link:=Doc.links.item(i,0)as IHTMLElement;

    ListBox1.Items.Add('-------'+IntToStr(Link.sourceIndex)+'-------');
    Anchor:=Link.innerText;

    if length(Trim(Anchor))>0 then
      ListBox1.Items.Add(': '+Anchor)
    else
      ListBox1.Items.Add('  -    ');

    ListBox1.Items.Add('href: '+ Link.getAttribute('href',0));
    RelAttr:=Link.getAttribute('rel',0);
    if length(Trim(RelAttr))>0 then
      begin
        ListBox1.Items.Add('rel: '+RelAttr);
        if pos('nofollow',lowercase(RelAttr))>0 then
          ListBox1.Items.Add('  GOOGLE');
      end;
    parent:=Link.parentElement as IHTMLElement;
    child:=parent.all as IHTMLElementCollection;

    for j:= Child.length - 1 downto 0 do
      begin
        Parent:=child.item(j,0) as IHTMLElement;
        if (Parent<>nil)and(Parent.sourceIndex<=(Link.sourceIndex-1)) then
          begin
            if Parent.tagName='NOINDEX' then
              begin
                ListBox1.Items.Add('    ');
                break;
              end;
          end;
      end;
  end;
end;

procedure TFMain.LoadDocument(const URL: string);
var Content: TStringList;
    V:OLEVariant;
begin
 with THTTPSend.Create do
    begin
      if HTTPMethod('GET',Edit1.Text) then
        begin
          Content:=TStringList.Create;
          Content.LoadFromStream(Document);
        end
      else
        raise Exception.Create('  ');
    end;
// 
Doc:=CoHTMLDocument.Create as IHTMLDocument2;
V:=VarArrayCreate([0,0],varVariant);
V[0]:=Content.Text;
Doc.write(PSafeArray(TVarData(v).VArray));
end;

end.
